/*
 * Decompiled with CFR 0.152.
 */
package com.lemonjk.fileselect;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.documentfile.provider.DocumentFile;
import com.lemonjk.fileselect.FileUtil;
import com.lemonjk.fileselect.ListViewAdapter;
import com.lemonjk.fileselect.R;
import java.io.File;

public class NativePageActivity
extends Activity {
    TextView navBarTitle;
    ListView listView1;
    DocumentFile tempLastDir;
    String packageName;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 23) {
            this.getWindow().getDecorView().setSystemUiVisibility(9216);
        }
        this.setContentView(R.layout.activity_list);
        ImageView back = (ImageView)this.findViewById(R.id.back);
        this.navBarTitle = (TextView)this.findViewById(R.id.navbartitle);
        this.listView1 = (ListView)this.findViewById(R.id.lv1);
        back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent();
                NativePageActivity.this.setResult(112, intent);
                NativePageActivity.this.finish();
            }
        });
        Intent intent = this.getIntent();
        if (intent != null) {
            String filePath = intent.getStringExtra("filePath");
            Uri uri = Uri.parse((String)filePath);
            DocumentFile documentFile = DocumentFile.fromTreeUri((Context)this, (Uri)uri);
            this.packageName = documentFile.getName();
            this.showFileListOnUI(documentFile);
        }
    }

    private void showFileListOnUI(DocumentFile documentFile) {
        Log.d((String)"fjh", (String)("\u5305\u540d\uff1a" + documentFile.getName()));
        this.navBarTitle.setText((CharSequence)documentFile.getName());
        if (documentFile.isDirectory()) {
            final DocumentFile[] fileList = documentFile.listFiles();
            if (fileList.length == 0) {
                this.listView1.setVisibility(8);
                return;
            }
            this.listView1.setVisibility(0);
            ListViewAdapter listViewAdapter = new ListViewAdapter((Context)this, R.layout.file_item, documentFile.listFiles());
            this.listView1.setAdapter((ListAdapter)listViewAdapter);
            this.listView1.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    DocumentFile documentFile1 = fileList[position];
                    if (documentFile1.isDirectory()) {
                        NativePageActivity.this.tempLastDir = documentFile1;
                        NativePageActivity.this.showFileListOnUI(documentFile1);
                    } else {
                        File file = FileUtil.saveFileToTempDir((Context)NativePageActivity.this, documentFile1.getUri());
                        String path = file.getAbsolutePath();
                        Log.d((String)"fjh", (String)("copyFileToTemp: " + path));
                        Intent intent = new Intent();
                        intent.putExtra("respond", path);
                        NativePageActivity.this.setResult(-1, intent);
                        NativePageActivity.this.finish();
                    }
                }
            });
        }
    }

    public void onBackPressed() {
        if (this.tempLastDir == null || this.packageName == null) {
            super.onBackPressed();
        } else if (this.packageName.equals(this.tempLastDir.getName())) {
            super.onBackPressed();
        } else {
            this.tempLastDir = this.tempLastDir.getParentFile();
            this.showFileListOnUI(this.tempLastDir);
        }
    }
}

