/*
 * Decompiled with CFR 0.152.
 */
package com.lemonjk.fileselect;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.documentfile.provider.DocumentFile;
import com.lemonjk.fileselect.R;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ListViewAdapter
extends ArrayAdapter<DocumentFile> {
    DocumentFile[] list;

    public ListViewAdapter(Context context, int resource, DocumentFile[] filelist) {
        super(context, resource, (Object[])filelist);
        this.list = filelist;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        View view;
        if (convertView == null) {
            view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.file_item, parent, false);
            viewHolder = new ViewHolder();
            viewHolder.fileIcon = (ImageView)view.findViewById(R.id.fileIcon);
            viewHolder.fileName = (TextView)view.findViewById(R.id.fileName);
            viewHolder.fileTime = (TextView)view.findViewById(R.id.fileTime);
            viewHolder.fileCount = (TextView)view.findViewById(R.id.fileCount);
            viewHolder.linkTo = (ImageView)view.findViewById(R.id.linkTo);
            view.setTag((Object)viewHolder);
        } else {
            view = convertView;
            viewHolder = (ViewHolder)view.getTag();
        }
        DocumentFile documentFile = this.list[position];
        viewHolder.fileName.setText((CharSequence)documentFile.getName());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(documentFile.lastModified()));
        String dateStr = format.format(new Date(documentFile.lastModified()));
        viewHolder.fileTime.setText((CharSequence)dateStr);
        if (documentFile.isDirectory()) {
            viewHolder.fileCount.setText((CharSequence)(String.valueOf(documentFile.listFiles().length) + "\u9879"));
            viewHolder.fileIcon.setImageResource(R.drawable.icon_folder);
        } else {
            viewHolder.fileCount.setText((CharSequence)(String.valueOf(documentFile.length() / 1024L) + "KB"));
            viewHolder.fileIcon.setImageResource(R.drawable.icon_file);
            viewHolder.linkTo.setVisibility(8);
        }
        return view;
    }

    private class ViewHolder {
        ImageView fileIcon;
        TextView fileName;
        TextView fileTime;
        TextView fileCount;
        ImageView linkTo;

        private ViewHolder() {
        }
    }
}

