/*
 * Decompiled with CFR 0.152.
 */
package com.lemonjk.fileselect;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.provider.DocumentsContract;
import android.util.Log;
import androidx.documentfile.provider.DocumentFile;
import com.alibaba.fastjson.JSONObject;
import com.lemonjk.fileselect.NativePageActivity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtil {
    public static void showAppDataFilePicker(Context context, String securityPackageName, int requestCode) {
        Uri uri = FileUtil.getAppDataUriByPackageName(securityPackageName);
        if (context != null) {
            Intent intent = new Intent(context, NativePageActivity.class);
            intent.putExtra("filePath", uri.toString());
            ((Activity)context).startActivityForResult(intent, requestCode);
        }
    }

    private static Uri getAppDataUriByPackageName(String packageName) {
        String appDataDir = "/storage/emulated/0/Android/data/";
        String destPath = "/storage/emulated/0/Android/data/" + packageName;
        destPath = destPath.replace("/storage/emulated/0/", "").replace("/", "%2F");
        destPath = "content://com.android.externalstorage.documents/tree/primary%3A" + destPath;
        return Uri.parse((String)destPath);
    }

    public static void requestSecurityScope(Context context, String securityPackageName, int requestCode) {
        Uri uri = FileUtil.getAppDataUriByPackageName(securityPackageName);
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT_TREE");
        intent.setFlags(195);
        DocumentFile documentFile = DocumentFile.fromTreeUri((Context)context, (Uri)uri);
        intent.putExtra("android.provider.extra.INITIAL_URI", (Parcelable)documentFile.getUri());
        ((Activity)context).startActivityForResult(intent, requestCode);
    }

    public static String getAbsolutePathFromUri(Context context, Uri uri) {
        if (uri == null) {
            return null;
        }
        Log.d((String)"fjh", (String)("selectedFileUri-toString" + uri));
        Log.d((String)"fjh", (String)("selectedFileUri-getPath" + uri.getPath()));
        Log.d((String)"fjh", (String)("selectedFileUri-getAuthority" + uri.getAuthority()));
        Log.d((String)"fjh", (String)("selectedFileUri-getScheme" + uri.getScheme()));
        if (Build.VERSION.SDK_INT >= 29) {
            return FileUtil.getFile_aboveSdk29(context, uri).getAbsolutePath();
        }
        return FileUtil.getFile_aboveSdk21(context, uri).getAbsolutePath();
    }

    private static File getFile_aboveSdk29(Context context, Uri uri) {
        return FileUtil.getFile_aboveSdk21(context, uri);
    }

    private static File getFile_aboveSdk21(Context context, Uri uri) {
        if (DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileUtil.isExternalStorageDocument(uri)) {
                Log.d((String)"fjh", (String)"isExternalStorageDocument");
                return FileUtil.saveFileToTempDir(context, uri);
            }
            if (FileUtil.isDownloadsDocument(uri)) {
                Log.d((String)"fjh", (String)"isDownloadsDocument");
                return FileUtil.saveFileToTempDir(context, uri);
            }
            if (FileUtil.isMediaDocument(uri)) {
                Log.d((String)"fjh", (String)"isMediaDocument");
                return FileUtil.saveFileToTempDir(context, uri);
            }
            return null;
        }
        Log.d((String)"fjh", (String)"\u975eSAF");
        if ("content".equalsIgnoreCase(uri.getScheme())) {
            return new File(FileUtil.queryColumData(context, uri, "_data", null, null));
        }
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            return new File(uri.getPath());
        }
        return null;
    }

    private static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String queryColumData(Context context, Uri uri, String columnName, String selection, String[] selectionArgs) {
        String column = columnName;
        String[] projection = new String[]{column};
        try (Cursor cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);){
            if (cursor != null && cursor.moveToFirst()) {
                int columnIndex = cursor.getColumnIndexOrThrow(column);
                String string = cursor.getString(columnIndex);
                return string;
            }
            Log.d((String)"fjh", (String)"getDataColumn: fail");
            return null;
        }
    }

    private static JSONObject queryColumnsData(Context context, Uri uri, String[] columns, String selection, String[] selectionArgs) {
        String[] projection = columns;
        JSONObject result = new JSONObject();
        try (Cursor cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);){
            if (cursor != null && cursor.moveToFirst()) {
                for (String column : columns) {
                    int columnIndex = cursor.getColumnIndexOrThrow(column);
                    Log.d((String)"fjh", (String)(column + ":" + cursor.getString(columnIndex)));
                    result.put(column, (Object)cursor.getString(columnIndex));
                }
            } else {
                Log.d((String)"fjh", (String)"getDataColumn: fail");
            }
        }
        return result;
    }

    public static File saveFileToPath(Context context, Uri fileUri, File destPath) {
        String destPathStr = destPath.getAbsolutePath();
        ContentResolver contentResolver = context.getContentResolver();
        JSONObject res = FileUtil.queryColumnsData(context, fileUri, new String[]{"_display_name"}, null, null);
        String displayName = res.getString("_display_name");
        try {
            InputStream is = contentResolver.openInputStream(fileUri);
            if (is != null) {
                int read;
                File destDir = new File(destPathStr);
                long timestamp = System.currentTimeMillis();
                File newFile = new File(destDir.getPath(), timestamp + "_" + displayName);
                FileOutputStream fos = new FileOutputStream(newFile);
                byte[] buffer = new byte[1024];
                while ((read = is.read(buffer)) != -1) {
                    fos.write(buffer, 0, read);
                }
                fos.close();
                is.close();
                return newFile;
            }
            Log.d((String)"fjh", (String)"is is null");
            return null;
        }
        catch (IOException e) {
            Log.d((String)"fjh", (String)e.toString());
            return null;
        }
    }

    public static File saveFileToTempDir(Context context, Uri fileUri) {
        return FileUtil.saveFileToPath(context, fileUri, context.getExternalCacheDir());
    }

    public static JSONObject buildFileInfo(Context context, File file) {
        if (!file.exists()) {
            return null;
        }
        String filePath = file.toString();
        String fileName = file.getName();
        Long fileSize = file.length();
        int extNameIdx = fileName.lastIndexOf(".");
        String fileExtName = extNameIdx != -1 ? fileName.substring(extNameIdx + 1) : "";
        JSONObject result = new JSONObject();
        result.put("fileName", (Object)fileName);
        result.put("filePath", (Object)filePath);
        result.put("fileSize", (Object)fileSize);
        result.put("fileExtension", (Object)fileExtName);
        return result;
    }
}

