/*
 * Decompiled with CFR 0.152.
 */
package com.lemonjk.fileselect;

import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.util.Log;
import com.alibaba.fastjson.JSONObject;
import com.lemonjk.fileselect.FileUtil;
import com.lemonjk.fileselect.LemonUtil;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.common.UniDestroyableModule;
import java.io.File;
import java.util.ArrayList;

public class FileSelectModule
extends UniDestroyableModule {
    public static String PERMISSION_FAIL_ERROR_CODE = "1001";
    public static String EXISTS_FAIL_ERROR_CODE = "1002";
    public static String OTHER_FAIL_ERROR_CODE = "-1";
    public static String SELECT_SUCCESS_ERROR_CODE = "0";
    public static String GRANT_SUCCESS_ERROR_CODE = "1005";
    public static String CONFIG_FAIL_ERROR_CODE = "2001";
    private static final int FILE_SELECT_REQUEST_CODE = 110;
    private static final int GRANT_READ_DATA_REQUEST_CODE = 111;
    public static final int DATA_FILE_SELECT_REQUEST_CODE = 112;
    static JSONObject options_temp;
    static UniJSCallback jsCallback_temp;
    public static Activity activity;
    private static int targetSdkVersion;

    @UniJSMethod(uiThread=true)
    public void showPicker(JSONObject options, UniJSCallback jsCallback) {
        if (this.mUniSDKInstance.getContext() instanceof Activity) {
            options_temp = options;
            jsCallback_temp = jsCallback;
            activity = (Activity)this.mUniSDKInstance.getContext();
            targetSdkVersion = FileSelectModule.activity.getApplicationInfo().targetSdkVersion;
            Log.d((String)"fjh", (String)("targetSdkVersion: " + targetSdkVersion));
            String securityScope = options.getString("securityScope");
            String securityPackageName = options.getString("securityPackageName");
            if ("data".equals(securityScope) && securityPackageName != null) {
                FileUtil.showAppDataFilePicker((Context)activity, securityPackageName, 112);
                return;
            }
            if (Build.VERSION.SDK_INT >= 33 && targetSdkVersion >= 33) {
                LemonUtil.requestPermission(activity, new String[]{"android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_AUDIO", "android.permission.READ_MEDIA_VIDEO"});
            } else {
                Log.d((String)"fjh", (String)"showPicker: READ_EXTERNAL_STORAGE");
                LemonUtil.requestPermission(activity, new String[]{"android.permission.READ_EXTERNAL_STORAGE"});
            }
        }
    }

    @UniJSMethod(uiThread=true)
    public void grantSecurityScope(JSONObject options, UniJSCallback jsCallback) {
        if (this.mUniSDKInstance.getContext() instanceof Activity) {
            options_temp = options;
            jsCallback_temp = jsCallback;
            activity = (Activity)this.mUniSDKInstance.getContext();
            targetSdkVersion = FileSelectModule.activity.getApplicationInfo().targetSdkVersion;
            String securityScope = options.getString("securityScope");
            String securityPackageName = options.getString("securityPackageName");
            if ("data".equals(securityScope) && securityPackageName != null) {
                FileUtil.requestSecurityScope((Context)activity, securityPackageName, 111);
            } else {
                JSONObject result = new JSONObject();
                result.put("code", (Object)CONFIG_FAIL_ERROR_CODE);
                result.put("errMsg", (Object)"fileSelect:fail");
                result.put("detail", (Object)"\u53c2\u6570\u914d\u7f6e\u9519\u8bef[securityScope,securityPackageName]");
                jsCallback_temp.invoke((Object)result);
            }
        }
    }

    private void showFilePickerUI() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        String mimeType = options_temp.getString("mimeType");
        String pathScope = options_temp.getString("pathScope");
        String multi = options_temp.getString("multi");
        intent.setType(mimeType);
        if ("yes".equals(multi)) {
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }
        intent.addCategory("android.intent.category.OPENABLE");
        if (pathScope != null) {
            pathScope = pathScope.replaceAll("/", "%2F");
            Uri dirUri = Uri.parse((String)("content://com.android.externalstorage.documents/document/primary%3A" + pathScope));
            intent.putExtra("android.provider.extra.INITIAL_URI", (Parcelable)dirUri);
        }
        activity.startActivityForResult(intent, 110);
    }

    private void handleFileSelectResult(int resultCode, Intent data) {
        if (resultCode == -1 && data != null) {
            JSONObject result = new JSONObject();
            ClipData clipData = data.getClipData();
            if (clipData != null) {
                ArrayList<JSONObject> files = new ArrayList<JSONObject>();
                for (int i = 0; i < clipData.getItemCount(); ++i) {
                    Uri uri = clipData.getItemAt(i).getUri();
                    String absolutePath = FileUtil.getAbsolutePathFromUri((Context)activity, uri);
                    files.add(FileUtil.buildFileInfo((Context)activity, new File(absolutePath)));
                }
                result.put("files", files);
                result.put("code", (Object)SELECT_SUCCESS_ERROR_CODE);
                result.put("errMsg", (Object)"fileSelect:ok");
                result.put("detail", (Object)"\u9009\u53d6\u6587\u4ef6\u6210\u529f");
                Log.d((String)"fjh", (String)result.toJSONString());
                jsCallback_temp.invoke((Object)result);
                return;
            }
            Uri selectedFileUri = data.getData();
            String absolutePath = FileUtil.getAbsolutePathFromUri((Context)activity, selectedFileUri);
            Log.d((String)"fjh", (String)("absolutePath" + absolutePath));
            if (absolutePath != null) {
                File file = new File(absolutePath);
                if (file.exists()) {
                    JSONObject[] files = new JSONObject[]{FileUtil.buildFileInfo((Context)activity, file)};
                    result.put("files", (Object)files);
                    result.put("code", (Object)SELECT_SUCCESS_ERROR_CODE);
                    result.put("errMsg", (Object)"fileSelect:ok");
                    result.put("detail", (Object)"\u9009\u53d6\u6587\u4ef6\u6210\u529f");
                    Log.d((String)"fjh", (String)result.toJSONString());
                    jsCallback_temp.invoke((Object)result);
                } else {
                    result.put("code", (Object)EXISTS_FAIL_ERROR_CODE);
                    result.put("errMsg", (Object)"fileSelect:fail");
                    result.put("detail", (Object)"\u6587\u4ef6\u4e0d\u5b58\u5728");
                    jsCallback_temp.invoke((Object)result);
                }
            } else {
                result.put("code", (Object)OTHER_FAIL_ERROR_CODE);
                result.put("errMsg", (Object)"fileSelect:fail");
                result.put("detail", (Object)"absolutePath is null");
                jsCallback_temp.invoke((Object)result);
            }
        }
    }

    private void handleGrantReadDataResult(int resultCode, Intent data) {
        if (resultCode == -1 && data != null) {
            Uri uri = data.getData();
            JSONObject result = new JSONObject();
            if (uri != null) {
                activity.getContentResolver().takePersistableUriPermission(uri, 3);
                result.put("code", (Object)GRANT_SUCCESS_ERROR_CODE);
                result.put("errMsg", (Object)"grant:ok");
                result.put("detail", (Object)"\u6587\u4ef6\u5939\u6388\u6743\u6210\u529f");
                jsCallback_temp.invoke((Object)result);
            }
        }
    }

    private void handleDataFileSelectResult(int resultCode, Intent data) {
        if (resultCode == -1 && data != null && data.hasExtra("respond")) {
            File file = new File(data.getStringExtra("respond"));
            JSONObject result = new JSONObject();
            JSONObject[] files = new JSONObject[]{FileUtil.buildFileInfo((Context)activity, file)};
            result.put("files", (Object)files);
            result.put("code", (Object)SELECT_SUCCESS_ERROR_CODE);
            result.put("errMsg", (Object)"fileSelect:ok");
            result.put("detail", (Object)"\u9009\u53d6\u6587\u4ef6\u6210\u529f");
            jsCallback_temp.invoke((Object)result);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 110: {
                this.handleFileSelectResult(resultCode, data);
                break;
            }
            case 111: {
                this.handleGrantReadDataResult(resultCode, data);
                break;
            }
            case 112: {
                this.handleDataFileSelectResult(resultCode, data);
                break;
            }
            default: {
                super.onActivityResult(requestCode, resultCode, data);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        Boolean isAllGranted = LemonUtil.checkPermission(permissions, grantResults);
        JSONObject result = new JSONObject();
        if (!isAllGranted.booleanValue()) {
            result.put("code", (Object)PERMISSION_FAIL_ERROR_CODE);
            result.put("errMsg", (Object)"fileSelect:fail");
            result.put("detail", (Object)permissions);
            jsCallback_temp.invoke((Object)result);
        } else {
            this.showFilePickerUI();
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @UniJSMethod(uiThread=true)
    public void gotoSetting(JSONObject options, UniJSCallback jsCallback) {
        if (this.mUniSDKInstance.getContext() instanceof Activity) {
            LemonUtil.goToSettingPage(this.mUniSDKInstance.getContext(), "android.settings.APPLICATION_DETAILS_SETTINGS");
        }
    }

    public void destroy() {
    }
}

